/// <reference path="jquery-1.3.2-vsdoc.js" />
/// <reference name="ajax.common.js" />

$(document).ready(function() {
    
    updateModelOnFormSubmit(
        $("#profileForm form"),
        function(url) { 
            if(!$("#profileForm form").valid()) return false;
            $("#profileForm").addClass("disabled");
            $("#profileForm .submit").addClass("loading");
            $("#profileForm *").attr("disabled", "disabled");
            $("#profileForm .status").remove();
            return true;
        },
        function(data) {
            if(!data.ReturnUrl) data.ReturnUrl = "/";
            $("#profileForm").removeClass("disabled");
            $("#profileForm .submit").removeClass("loading");
            $("#profileForm *").attr("disabled", null);
            
            $("<span class='status'>Profile update successfully | <a href='" + data.ReturnUrl + "'>Continue</a> | </span>")
                .insertBefore($("#profileForm input[type=submit]"));
            
        });
});